/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*********************************************************************************/
/* Test code to verify Bitload BIS
/* Standalone code
/* Sets up the handshake parameters and calls BgMedley_bitload
/* Takes predefined SNRs, defined in snr_data.c; we also have best option 60 dB on all tones,
/* to test pms selection such that gs_TotalBitsSupported is not the limiting factor

  /* Runs for two cases : 1) Trellis is on
  2) Trellis off

   /* Runs through a set of max data rates, max latency and min overhead rates
   /* Output is in files results_pms_trellis_on.dat & results_pms_trellis_off.dat


/********************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "gdata.h"
#include "bitload2.h"
#include "bitload.h"
#include "bitload_const.h"
#include "compiler.h"
#include "cmv.h"
#include "cmv_data.h"
#include "const.h"
#include "statein1.h"
#include "states.h"
#include "changebat.h"
#include "pll.h"
#include "snr_data.h"

#include "ComputeRMSFineGain.h"
#include "snr.h"
#include "decimalgain.h"
#include "showinit.h"
#include "dsp_op.h"
#include "ghs.h"
#include "hndshk_Data.h"
#include "bitload_support.h"
#include "tone_ord.h"

// Local functions
C_SCOPE int16 VerifyBat(uint8 *psa_Bat);

// Define local buffers for SNRs, BAT.
int16 *gsa_my_MedleySnrBuf;

int16 gsa_my_RxShowtimeSnrBuf[256];

int16 gsa_my_RxShowtimeSnrBuf_Plus[512];

int16 gsa_my_RxFineGains[RX_NUM_TONES];
int16 gsa_my_RxToneOrder[RX_NUM_TONES];
int16 gsa_NoiseSeparationSnrAdjArray[RX_NUM_TONES];

int16 gs_maxdatarate_in;

FILE *file_pms;
FILE *file_pms1;

int16 gs_maxlatency;
extern int16  gs_iter_conv;
extern int16 gs_found_valid_config, gs_flag_fixedrate, gs_tcm_coding_gain, gs_max_coding_gain, gs_flag_limitedrate;

extern int16  gsa_my_MedleySnrBuf_10kft[256],  gsa_my_MedleySnrBuf_0kft[256], gsa_my_MedleySnrBuf_16kft[256],gsa_my_MedleySnrBuf_18kft[256], gsa_my_MedleySnrBuf_test[256], gsa_my_MedleySnrBuf_18kft_500bt[256];
extern int16 gsa_test_snr_increase[256], gsa_test_snr_decrease[256], gsa_test_snr_increase_decrease[256], gsa_my_MedleysnrBuf_3kft[256], gsa_my_MedleySnrBuf_longloop[256], gsa_my_MedleySnrBuf_longloop1[256];

extern int16 gsa_my_MedleySnrBuf_plus[512];
extern int16 gsa_my_MedleySnrBuf_plus_9kft[512];
extern int16 gsa_my_MedleySnrBuf_plus_12kft[512];
extern int16 gsa_my_MedleySnrBuf_plus_9kftmod[512];
extern int16 gs_MSGc_final, gs_seq_final, gs_per_final;
extern FlagT gft_EnableNomATP;

int16 gs_BytesForBC0_final, gs_BytesForBC1_final, gs_Kp_MDF_final, gs_Dp_final, gs_Mp_final;
int16 gs_Rp_final, gs_Lp_final, gs_Tp_final, gs_TCM_Oh_final, gs_CWSize_final, gs_Sp_final;
int16  gs_net_datarate_final, gs_ovhd_rate_final, gs_latency_final;

int16 gs_BytesForBC0_final_LP0, gs_BytesForBC1_final_LP0, gs_Kp_MDF_final_LP0, gs_Dp_final_LP0, gs_Mp_final_LP0;
int16 gs_Rp_final_LP0, gs_Lp_final_LP0, gs_Tp_final_LP0, gs_TCM_Oh_final_LP0, gs_CWSize_final_LP0, gs_Sp_final_LP0;
int16  gs_net_datarate_final_LP0, gs_ovhd_rate_final_LP0, gs_latency_final_LP0;

int16 gs_BytesForBC0_final_LP1, gs_BytesForBC1_final_LP1, gs_Kp_MDF_final_LP1, gs_Dp_final_LP1, gs_Mp_final_LP1;
int16 gs_Rp_final_LP1, gs_Lp_final_LP1, gs_Tp_final_LP1, gs_TCM_Oh_final_LP1, gs_CWSize_final_LP1, gs_Sp_final_LP1;
int16  gs_net_datarate_final_LP1, gs_ovhd_rate_final_LP1, gs_latency_final_LP1;

int16 gs_ovhdrate_in, gs_INP_in, s_max_datarate_lim = 3073,j, i_desired_margin;
int16 s_iter_total, test_run, test_case;
int16 s_Lp_est, s_ncloaded_est,s_TCM_Oh_est;
float datarate_final, datarate_diff, datarate_msgc;
char file_tcm_on[50], file_tcm_off[50];

int16 s_RSCodingGain, s_error_code = 0, s_max_margin = 0, s_desired_margin, step_rate;
int32 l_Prod;
int16 Desired_Margin[5] = {0, 589, 1536, 3072, 4096};  // Desired margin 8.8
int16 Max_Margin[7] = {0, 60, 100, 150, 310, 510, 511 };  // Max margin 10* dB value

int16  gs_DS_RateOption;               /* final downstream rate option */
RMsgRA_t gt_RMsgRA;
RMsg2_t gt_RMsg2;                /* R_MSG2 parameters */
Option_t gta_DS_options[NUM_DS_RATE_OPTIONS];
int16 s_delta_Lp, s_ActualDeltaSumLp, s_OhTcm;
int16 gsa_RxFineGainsLin[RX_NUM_TONES];


int16 s_FGainLin, s_MaxNomATP_DS, s_NOMATP_DS;
int16 s_temp, s_nomATP_dB;

int32 l_SumFGainLinSq, l_SumFGainLinSq_sub, l_AddGiSqTssiSq, l_GiSqTssiSq, l_test;
float float_nomATP_dB;


extern int16 s_minbitsLP1, sumBi, s_minbitsLP1toconsider, s_actualbitsLp1;
extern int16   s_numTonesLp1,   s_Rx_Tcm_Num1bits, s_Tcm_Oh,s_InitialSumBi;
//extern int16  s_path;
extern uint16 s_ncloadedLP1;
// One-bit-per-tone array used to indicate which tones are allocated to Latency Path #1
extern RxToneFlags p_TonesAllocatedtoLP1_DS;
#define STAT_ConfigMode_ADSL2_ALL      (STAT_ConfigMode_G992_3_ALL | STAT_ConfigMode_G992_5_ALL)
//#define   STAT_ConfigMode_G992_3_ALL  STAT_ConfigMode_G992_3_A;
int16 gs_resrate_BC1;
extern int16 gs_saveBitstoreduce;
extern uint16 gus_ncloaded_LP1;

#define IRIDIA_30     0x20      // corresponds to iridia BM 3.0

uint16 gusa_DS_Tssi_Value[512]={ 1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1024,
       1014,
       1004,
        995,
        985,
        976,
        967,
        958,
        949,
        940,
        931,
        923,
        914,
        906,
        897,
        889,
        881,
        872,
        864,
        856,
        848,
        840,
        832,
        824,
        816,
        809,
        801,
        794,
        786,
        779,
        771,
        764,
        757,
        750,
        743,
        736,
        729,
        722,
        715,
        708,
        702,
        695,
        689,
        682,
        676,
        669,
        663,
        657,
        651,
        644,
        638,
        633,
        627,
        621,
        615,
        609,
        603,
        598,
        592,
        586,
        581,
        575,
        570,
        564,
        559,
        554,
        549,
        543,
        538,
        533,
        528,
        523,
        518,
        513,
        509,
        504,
        499,
        494,
        490,
        485,
        480,
        476,
        472,
        467,
        463,
        458,
        454,
        450,
        445,
        441,
        437,
        433,
        429,
        425,
        421,
        417,
        413,
        409,
        405,
        401,
        398,
        394,
        390,
        387,
        383,
        379,
        376,
        372,
        369,
        365,
        362,
        359,
        355,
        352,
        349,
        345,
        342,
        339,
        336,
        332,
        329,
        323,
        323,
        323,
        322,
        322,
        322,
        321,
        321,
        321,
        320,
        320,
        319,
        319,
        319,
        318,
        318,
        318,
        317,
        317,
        317,
        316,
        316,
        316,
        315,
        315,
        315,
        314,
        314,
        313,
        313,
        313,
        312,
        312,
        312,
        311,
        311,
        311,
        310,
        310,
        310,
        309,
        309,
        309,
        308,
        308,
        308,
        307,
        307,
        307,
        306,
        306,
        305,
        305,
        305,
        304,
        304,
        304,
        303,
        303,
        303,
        302,
        302,
        302,
        301,
        301,
        301,
        300,
        300,
        300,
        299,
        299,
        299,
        298,
        298,
        298,
        297,
        297,
        297,
        296,
        296,
        296,
        295,
        295,
        295,
        294,
        294,
        294,
        293,
        293,
        293,
        292,
        292,
        292,
        291,
        291,
        291,
        290,
        290,
        290,
        289,
        289,
        289,
        288,
        288,
        288,
        287,
        287,
        287,
        287,
        286,
        286,
        286,
        285,
        285,
        285,
        284,
        284,
        284,
        283,
        283,
        283,
        282,
        282,
        282,
        281,
        281,
        281,
        280,
        280,
        280,
        280,
        279,
        279,
        279,
        278,
        272};
#define DEFAULT_NOMPSD_DS  -40               /* absolute default DS NOMPSD (dBm/Hz) */
#define DEFAULT_MAXNOMATP_DS_204 204            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
#define TEN_LOG_DELTA_F (9305)         /* 36.35 = 10*log10(4312.5) in Q8.8 */
#define C_10LOG10_2 (771)              /* 10log10(2) in Q8.8 */

// global variables
#define RX_MAX_BITS_PER_TONE     (15)        /*  maximum number of bits per tone at RX */

#define OPTN_FavorINPOverRate          0x0800   // Favor INP = 2frames over rate in case handshake INP is less

DebugTrailTriggerControl_t gt_debugTrailTriggerControl;
DebugTrailCollectControl_t gt_debugTrailCollectControl;

// Dummy function.  We don't need this functionality for this test.
void DebugTrail(int16 s_count, ... )
{}

void copy_my_medley_snr(int16 *psa_destBuf, int16 *psa_srcBuf)
{
   int16 i;

   for (i = 0; i < 512; i++)
   {
      psa_destBuf[i] = psa_srcBuf[i];
   }
}

int main(int argc, char **argv)
//void main()
{
   int16 i;
   int32 gl_Rx_Total_Power=0;                      /*  average received signal power */
   int16 INP;
   int16 s_BatCheck,  s_Tcm_Oh,s_InitialSumBi ;
   float s_actual_inp;

   /*******************************************************************************
   Initialize Global Variables
   ********************************************************************************/
   gs_TxNumTones = 32;

   if (gs_TxNumTones == 32) {

#ifndef EXTENDED_REACH_MODE_ON
      gs_RxFirstChannel = 33;
#else
      gs_RxFirstChannel = 6;
#endif


      gs_RxLastChannel = 255;

   }
   else { // Annex B
      gs_RxFirstChannel = 64;
      gs_RxLastChannel = 255;
   }

   /* for cocomo testing limit the max CWSize to be 240; this is because of bm limitation of
   TDP CO, will be removed in next upgrade*/
#ifdef WIN32
   gs_max_CWSize = 247;
#else
   gs_max_CWSize = 255;
#endif

   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   //gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_16kft;
   gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_10kft;
   //gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_0kft;

   //gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_test;

   // Point Task layer pointers to locally defined buffers.

   copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

   gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf;
   gsa_RxFineGains = gsa_my_RxFineGains;
   gsa_RxToneOrder = gsa_my_RxToneOrder;



   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   // STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_A;
   // STAT_ConfigMode_G992_3_ALL = STAT_ConfigMode_G992_3_A;
   //    STAT_ConfigMode_ADSL2_ALL  =(STAT_ConfigMode_G992_3_A | STAT_ConfigMode_G992_5_A);
   STATArray[STAT_Mode] = (int16)STAT_ConfigMode_ADSL2_ALL;
   gl_SelectedMode = MODE_G992_5 | ANNEX_A;


   //#define STAT_ConfigMode_ADSL2_ALL    (STAT_ConfigMode_G992_3_ALL | STAT_ConfigMode_G992_5_ALL)

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_CPilotTone = C_PILOT_TONE_64;

   gs_AuxPilotToneIdx = gs_CPilotTone;
   gft_AuxPilot = AUX_PILOT_DISABLE;

   OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;



// file_pms=fopen("TEST.txt","w");

   guc_Iridia_Revision_Number = IRIDIA_30;



   gs_RxLastChannel = 511;
   gs_max_CWSize = 255;


   gs_RxBitLoadFirstChannel = gs_RxFirstChannel;
   gs_RxBitLoadLastChannel = gs_RxLastChannel;

   gft_FineGainOn = TRUE;

   gs_max_fine_gain =  640;      // 2.5dB in Q 8.8
   gs_min_fine_gain = -640;      // -2.5dB in Q8.8


   guca_RSCodingGain[0] = 0;
   guca_RSCodingGain[1]= RS_CODING_GAIN_2;
   guca_RSCodingGain[2]= RS_CODING_GAIN_4;
   guca_RSCodingGain[3]= RS_CODING_GAIN_6;
   guca_RSCodingGain[4]= RS_CODING_GAIN_8;
   guca_RSCodingGain[5]= RS_CODING_GAIN_10;
   guca_RSCodingGain[6]= RS_CODING_GAIN_12;
   guca_RSCodingGain[7]= RS_CODING_GAIN_14;
   guca_RSCodingGain[8]= RS_CODING_GAIN_16;

   for (i=0 ; i< RX_NUM_TONES ; i++)
      gsa_RxToneOrder[i] = i;

   for (i=gs_RxFirstChannel ; i<=gs_RxLastChannel ; i++)
      SETTONEFLAG(p_MEDLEYset_DS, i);

   // define BIS for standalone test
   gft_ModemType = G_DMT_BIS;

   // STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;
   STATArray[STAT_Mode] = (int16)STAT_ConfigMode_ADSL2_ALL;
   gl_SelectedMode = MODE_G992_5 | ANNEX_A;

   /*  We re-allocate the default values to the HS_BIS structure before entering bit-loading. */
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
//    gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = 0;

   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP0_DATA_PATH] = (int16) 64;


   guc_MaxAllocBitsPerTone = RX_MAX_BITS_PER_TONE;

   gs_AuxPilotToneIdx = gs_CPilotTone;

   // Populate LP1 handhhake structure

   gt_HandshakeBis.sa_DS_MinINPBC[LP1_DATA_PATH] = 0;
   gt_HandshakeBis.sa_DS_MaxDataRateLP[LP1_DATA_PATH] = 100;
   gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP1_DATA_PATH] = 0;
   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP1_DATA_PATH] = 1;
   gt_HandshakeBis.sa_DS_MaxNetDataRateBC[LP1_DATA_PATH] = 1000;
   //    gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[LP1_DATA_PATH]  = 32;
   gt_HandshakeBis.sa_DS_MaxLatencyBC[LP1_DATA_PATH] = 1;
   gt_HandshakeBis.sa_DS_BCActive[0] = 1;
   gt_HandshakeBis.sa_DS_BCActive[1] = 1;
   gt_HandshakeBis.s_NumDSLatencyPaths = 2;     /* DS number of latency paths activated */

   gt_HandshakeBis.sa_DS_MaxIntlvDepthLP[LP1_DATA_PATH] = (int16) 64;
         gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP1_DATA_PATH] = 0;

   gpsa_NoiseSeparationSnrAdj = gsa_NoiseSeparationSnrAdjArray;
   for (test_case = 0; test_case<2; test_case++)
   {

      if (test_case ==0)
      {
         gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = (int16) (2* MAX_R_LP0_DS);
         file_pms=fopen(argv[1],"w");
//       file_pms=fopen("test1.txt", "w");
         fprintf(file_pms, "\n Max Check Bytes LP0 = 16 \n");

      }
      else if (test_case == 1)
      {
         gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] = 0; // Both paths are fast path
         file_pms=fopen(argv[2],"w");
//       file_pms=fopen("test2.txt","w");
         fprintf(file_pms, "\n Max Check Bytes LP0 = 0 ; FAST PATH \n");
      }




      for (test_run=0; test_run <4; test_run++)
      {
         if(test_run==0) // set the parameters for tcm on
         {
            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus; // 0ft
            fprintf(file_pms, "\n\t NULL LOOP \n");
         }

         if (test_run==1)
         {
            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_12kft;
            fprintf(file_pms, "\n\t 12 KFT LOOP \n");
         }

         if(test_run==2) // set the parameters for tcm on
         {
            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_9kftmod;
            fprintf(file_pms, "\n \t 9kft modified LOOP \n");
         }

         if (test_run==3)
         {
            gsa_my_MedleySnrBuf = gsa_my_MedleySnrBuf_plus_9kft;
            fprintf(file_pms, "\n\t 9KFT LOOP \n");
         }




         OPTNArray[OPTN_AlgControl2] = !OPTN_FavorINPOverRate;


         OPTNArray[OPTN_AlgControl] = 0x0FF8;
         gs_tcm_coding_gain = TCM_CODING_GAIN;
         gs_max_coding_gain = MAX_CODING_GAIN;

         // Point Task layer pointers to locally defined buffers.

         copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

         gsa_RxShowtimeSnrBuf = gsa_my_RxShowtimeSnrBuf_Plus;
         gsa_RxFineGains = gsa_my_RxFineGains;
         gsa_RxToneOrder = gsa_my_RxToneOrder;

         /*  SNR's (in dB) required for QAM */

         gsa_ConstellationSNR[0] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[1] = 0x0B4F;   /*  11.31 dB =  1 bit (NOT USED) */
         gsa_ConstellationSNR[2] = 0x0E51; /*  14.32 dB =  2 bits  */
         gsa_ConstellationSNR[3] = 0x131C;   /*  19.11 dB =  3 bits */
         gsa_ConstellationSNR[4] = 0x154F;   /*  21.31 dB =  4 bits */
         gsa_ConstellationSNR[5] = 0x1875;   /*  24.46 dB =  5 bits */
         gsa_ConstellationSNR[6] = 0x1B8A;   /*  27.54 dB =  6 bits */
         gsa_ConstellationSNR[7] = 0x1E97;   /*  30.59 dB =  7 bits */
         gsa_ConstellationSNR[8] = 0x219C;   /*  33.61 dB =  8 bits */
         gsa_ConstellationSNR[9] = 0x24A1;   /*  36.63 dB =  9 bits */
         gsa_ConstellationSNR[10] = 0x27A6; /*  39.65 dB = 10 bits */
         gsa_ConstellationSNR[11] = 0x2AA8; /*  42.66 dB = 11 bits */
         gsa_ConstellationSNR[12] = 0x2DAB; /*  45.67 dB = 12 bits */
         gsa_ConstellationSNR[13] = 0x30AE;  /*  48.68 dB = 13 bits */
         gsa_ConstellationSNR[14] = 0x33B0; /*  51.69 dB = 14 bits */
         gsa_ConstellationSNR[15] = 0x36B3; /*  54.70 dB = 15 bits */

         gt_HandshakeBis.s_OneOverSminADSL2 = 3;

         //       fprintf(file_pms, "INP\t maxrate\t msg_ovhdrate\t maxlatency\t Kp\t Dp\t Mp\t Rp\t Lp\t Tp\t CWSize\t Sp(8.8)\t net_datarate\t ovhd_rate\t latency_achvd\t INP_achvd\t  datarate\t diff_rate\t Ex_code\t  SEQp\t MSGc\t PERp\t MSGc_rate\t\n");
         fprintf(file_pms, " INP \t GHSMinrate LP1\t Lp (LP1)\t NetRate (LP1)\t LP (LP0)\t NetRateLP0\t  MaxToneLP1\t BitstoReduce \t Total Capacity \t \n");

         /***********************************************************************
         Loop thru various values of max data rate, overhead rate and latency

         ***********************************************************************/
         for (gs_INP_in = 0 ; gs_INP_in < 4 ; gs_INP_in++)
         {
            /* Initialize the handshake parameters for standalone test */

               if (gs_INP_in == 0)
               {
                  /* Initialize the handshake parameters for standalone test */
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 0;
                  s_actual_inp = 0;
               }
               else if (gs_INP_in == 1)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 1; // 0.5 frame protection
                  s_actual_inp = 0.5;
               }
               else if (gs_INP_in == 2)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 2; // 1 frame protection
                  s_actual_inp = 1;
               }
               else if (gs_INP_in == 3)
               {
                  gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] = 4; // 2 frame protection
                  s_actual_inp = 2;
               }

            gs_maxdatarate_in = 6136;

            for (gs_ovhdrate_in = 4; gs_ovhdrate_in < 6; gs_ovhdrate_in+=8)
            {
               for (gs_maxlatency =20; gs_maxlatency < 25; gs_maxlatency += 6)
               {
                  for (gs_resrate_BC1 = 32; gs_resrate_BC1 < 300; gs_resrate_BC1 +=8)
                  {

                     gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[LP1_DATA_PATH]  = gs_resrate_BC1;

                     gt_HandshakeBis.sa_DS_MaxDataRateLP[LP0_DATA_PATH] = 8000;


                     gt_HandshakeBis.sa_DS_MaxNetDataRateBC[0] = gs_maxdatarate_in;


                     gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0]  = 8;


                     gt_HandshakeBis.s_MinMSGDSOverheadRate = gs_ovhdrate_in;

                     gt_HandshakeBis.sa_DS_MaxLatencyBC[0] = gs_maxlatency;
                     /* define which Bearer channels and latency paths are active */

                     gt_HandshakeBis.sa_DS_BCActive[0] = 1;
                     gt_HandshakeBis.sa_DS_BCActive[1] = 1;
                     gt_HandshakeBis.s_NumDSLatencyPaths = 2;     /* DS number of latency paths activated */

                     // initialize the margin to be 6 dB
                     gs_RxDesiredMargin=DESIRED_SNR_MARGIN;

                     gs_RxNumTones=512;


                     /*****************************************************************
                     Initialze the medley and reverb3 snr and RX num Tones
                     *****************************************************************/

                     for(i=0;i<gs_RxNumTones;i++)
                     {
                        gpsa_NoiseSeparationSnrAdj[i] = 0;

                        gsa_ReverbSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                        gsa_ReverbEchoSnrBuf[i]=(int16)(gsa_my_MedleySnrBuf[i]);
                     }

                     copy_my_medley_snr(gsa_MedleySnrBuf, gsa_my_MedleySnrBuf);

                     // calls bitload_bis
                     BgMedleyBitload_bis();

                     GetBatStats(guca_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &gus_ncloaded, &gus_Rx_Tcm_Num1bits, &s_Tcm_Oh, &s_InitialSumBi, COMBINED_LP);

                     gs_BisToneOrderIntlvDepth = 4;   // Indicates interleaving depth for Bis tone-ordering

                     RxToneOrderingBis(guca_RxBat, gs_RxNumTones, (int16)gus_ncloaded , gus_Rx_Tcm_Num1bits, gsa_RxToneOrder);

                     if (gt_HandshakeBis.s_NumDSLatencyPaths==1)
                     {
                        if (gft_BitloadOK == 1)
                        {
                           //compute back the final parameters, mainly to see the final results on data rates and final latency
                           gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                           gs_BytesForBC1_final =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                           gs_Kp_MDF_final=gs_BytesForBC0_final + gs_BytesForBC1_final + 1;
                           gs_Dp_final=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                           gs_Mp_final=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                           gs_Rp_final=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                           gs_Lp_final=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                           gs_Tp_final=gt_PMSParams.s_Tp[LP0_DATA_PATH];

                           if(gft_TcmFlag_bis_DS == TRUE)
                           {
                              gs_TCM_Oh_final =(((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
                           }
                           else
                              gs_TCM_Oh_final=0;

                           gs_CWSize_final = gs_Kp_MDF_final*gs_Mp_final + gs_Rp_final;

                           gs_Sp_final = (int16)(8 * gs_CWSize_final*256/ gs_Lp_final); // Sp in 8.8 format

                           // net data rate (bits per frame)
                           gs_net_datarate_final = (int16)((((gs_Tp_final*gs_Kp_MDF_final-1)*gs_Mp_final*((int32)(gs_Lp_final*16)))/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final))+8)/16);

                           // overhead rate is in kbps (final rate is in 8.8 format)
                           gs_ovhd_rate_final=(int16)((gs_Mp_final*((int32)gs_Lp_final)*4*256)/(gs_Tp_final*(gs_Kp_MDF_final*gs_Mp_final+gs_Rp_final)));
                           gs_latency_final= (int16)((int32)gs_Sp_final * gs_Dp_final / 4); // 8.8 format (ms)

                           s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                           /**************************************************************************************
                           INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                           ***************************************************************************************/

                           if(gs_CWSize_final != 0)
                              INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                           else
                              INP=0;

                              /**************************************************************************************
                              Save the final computed parameters
                           ***************************************************************************************/
                           datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));

                           datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                           /* compute RMS fine gain value */
                           l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                           gt_TxPMDControl.us_RMSGI_DS  = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));

                           if (gt_TxPMDControl.us_RMSGI_DS > 0)
                           {
                              s_error_code = 2;
                           }


                           if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
                           {
                              fprintf(file_pms,"%8.1f\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %ld\t   %ld\t", s_actual_inp ,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final,gus_BitloadExceptionCode,   gt_TxPMDControl.us_RMSGI_DS);

                              fprintf(file_pms, "***ERROR:");
                              // First check for BitloadOK failure
                              if (gft_BitloadOK == FAIL)
                                 fprintf(file_pms, "BitloadOK=FAIL***\n");
                              // Then if BitloadOK is ok, check for bad Bat.
                              else if (s_BatCheck == FAIL)
                                 fprintf(file_pms, "Bad BAT***\n");
                              ;
                           }
                           else
                              fprintf(file_pms,"%8.1f\t   %ld\t %ld\t %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t  %ld  %ld\t\n", s_actual_inp,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final, gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final, gus_BitloadExceptionCode,  gt_TxPMDControl.us_RMSGI_DS);
                        }
                     }
                     else if (gt_HandshakeBis.s_NumDSLatencyPaths==2)
                     {
                        //dual latency
                        //compute back the final parameters, mainly to see the final results on data rates and final latency
                        // Latency Path 1
                        if (gft_BitloadOK == 1)
                        {
                           //    gs_BytesForBC0_final = gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                           gs_BytesForBC1_final_LP1 =  gt_PMSParams.sa_Bpn[LP1_DATA_PATH][DS_AS1_BEARER_CHANNEL];
                           gs_Kp_MDF_final_LP1= gs_BytesForBC1_final_LP1 + 1;
                           gs_Dp_final_LP1=gt_PMSParams.s_Dp[LP1_DATA_PATH];
                           gs_Mp_final_LP1=gt_PMSParams.s_Mp[LP1_DATA_PATH];
                           gs_Rp_final_LP1=gt_PMSParams.s_Rp[LP1_DATA_PATH];
                           gs_Lp_final_LP1=gt_PMSParams.s_Lp[LP1_DATA_PATH];
                           gs_Tp_final_LP1=gt_PMSParams.s_Tp[LP1_DATA_PATH];


                           gs_CWSize_final_LP1 = gs_Kp_MDF_final_LP1*gs_Mp_final_LP1 + gs_Rp_final_LP1;
                           gs_Sp_final_LP1 = (int16)(8 * gs_CWSize_final_LP1*256/ gs_Lp_final_LP1); // Sp in 8.8 format

                           // net data rate (bits per frame)
                           gs_net_datarate_final_LP1 = (int16)((((gs_Tp_final_LP1*gs_Kp_MDF_final_LP1-1)*gs_Mp_final_LP1*((int32)(gs_Lp_final_LP1)))/(gs_Tp_final_LP1*(gs_Kp_MDF_final_LP1*gs_Mp_final_LP1+gs_Rp_final_LP1))));

                           // overhead rate is in kbps (final rate is in 8.8 format)
                           gs_ovhd_rate_final_LP1=(int16)((gs_Mp_final_LP1*((int32)gs_Lp_final_LP1)*4*256)/(gs_Tp_final_LP1*(gs_Kp_MDF_final_LP1*gs_Mp_final_LP1 + gs_Rp_final_LP1)));
                           gs_latency_final_LP1= (int16)((int32)gs_Sp_final_LP1 * gs_Dp_final_LP1 / 4); // 8.8 format (ms)

                           // LP0 Data
                           gs_BytesForBC0_final_LP0 =  gt_PMSParams.sa_Bpn[LP0_DATA_PATH][DS_AS0_BEARER_CHANNEL];
                           gs_Kp_MDF_final_LP0= gs_BytesForBC0_final_LP0 + 1;
                           gs_Dp_final_LP0=gt_PMSParams.s_Dp[LP0_DATA_PATH];
                           gs_Mp_final_LP0=gt_PMSParams.s_Mp[LP0_DATA_PATH];
                           gs_Rp_final_LP0=gt_PMSParams.s_Rp[LP0_DATA_PATH];
                           gs_Lp_final_LP0=gt_PMSParams.s_Lp[LP0_DATA_PATH];
                           gs_Tp_final_LP0=gt_PMSParams.s_Tp[LP0_DATA_PATH];


                           gs_CWSize_final_LP0 = gs_Kp_MDF_final_LP0*gs_Mp_final_LP0 + gs_Rp_final_LP0;
                           if (gs_CWSize_final_LP0 !=0)
                           {
                              gs_Sp_final_LP0 = (int16)(8 * gs_CWSize_final_LP0*256/ gs_Lp_final_LP0); // Sp in 8.8 format

                              // net data rate (bits per frame)
                              gs_net_datarate_final_LP0 = (int16)((((gs_Tp_final_LP0*gs_Kp_MDF_final_LP0-1)*gs_Mp_final_LP0*((int32)(gs_Lp_final_LP0)))/(gs_Tp_final_LP0*(gs_Kp_MDF_final_LP0*gs_Mp_final_LP0+gs_Rp_final_LP0))));
                           }
                           // overhead rate is in kbps (final rate is in 8.8 format)
                           gs_ovhd_rate_final_LP0=(int16)((gs_Mp_final_LP0*((int32)gs_Lp_final_LP0)*4*256)/(gs_Tp_final_LP0*(gs_Kp_MDF_final_LP0*gs_Mp_final_LP0+gs_Rp_final_LP0)));
                           gs_latency_final_LP0= (int16)((int32)gs_Sp_final_LP0 * gs_Dp_final_LP0 / 4); // 8.8 format (ms)

                           //
                           gs_Lp_final = gs_Lp_final_LP0 + gs_Lp_final_LP1;
                           s_BatCheck = VerifyBat((uint8 *)&guca_RxBat[0]);
                           /**************************************************************************************
                           INP is impulse noise protection = (1/2) (S*D) (R/CWSize)
                           ***************************************************************************************/

#ifdef TESTALL
                           if(gs_CWSize_final != 0)
                              INP = (gs_Sp_final*gs_Dp_final * gs_Rp_final/(2*gs_CWSize_final));

                           else
                              INP=0;

                              /**************************************************************************************
                              Save the final computed parameters
                           ***************************************************************************************/
                           datarate_final = (float)(  (gs_Tp_final * gs_Kp_MDF_final - 1) *  gs_Mp_final * (float)(gs_Lp_final) / (gs_Tp_final * gs_CWSize_final));

                           datarate_msgc = (float) (gs_ovhd_rate_final* gs_MSGc_final)/(256*(gs_MSGc_final+6));

                           /* compute RMS fine gain value */
                           l_Prod = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

                           gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_Prod)  -  ConvertToDB(8192));

                           if (gt_TxPMDControl.us_RMSGI_DS > 0)
                           {
                              s_error_code = 2;
                           }

#endif

                           if ((s_BatCheck == FAIL) || (gft_BitloadOK == FAIL))
                           {
                              //                         fprintf(file_pms,"%ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t %ld\t   %ld\t",gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] ,  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,  gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP, datarate_final,gus_BitloadExceptionCode,   gt_TxPMDControl.us_RMSGI_DS);
                              fprintf(file_pms," %8.1f\t %ld\t %ld\t %ld\t   %ld\t  %ld\t  %ld\t  %ld\t  %ld\t ", s_actual_inp, gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[1], gs_Lp_final_LP1,   gs_net_datarate_final_LP1, gs_Lp_final_LP0, gs_net_datarate_final_LP0,  gs_MaxToneForFast, gs_saveBitstoreduce, gs_Lp_final_LP1+gs_Lp_final_LP0+gs_saveBitstoreduce);

                              fprintf(file_pms, "***ERROR:");
                              // First check for BitloadOK failure
                              if (gft_BitloadOK == FAIL)
                                 fprintf(file_pms, "BitloadOK=FAIL***\n");
                              // Then if BitloadOK is ok, check for bad Bat.
                              else if (s_BatCheck == FAIL)
                                 fprintf(file_pms, "Bad BAT***\n");
                              ;
                           }
                           else
                              //                   fprintf(file_pms,"%ld\t   %ld\t %ld\t %ld\t%ld\t %ld\t %ld\t %ld\t %ld\t %ld\t  %ld\t %ld\t %ld\t  %ld\t %ld\t %8.2f\t  %ld  %ld\t\n", gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH],  gs_ovhdrate_in, gs_maxlatency,  gs_Kp_MDF_final,   gs_Dp_final,   gs_Mp_final,   gs_Rp_final, gs_Lp_final,  gs_Tp_final,gs_CWSize_final,gs_Sp_final,gs_net_datarate_final,gs_ovhd_rate_final,gs_latency_final, INP,  datarate_final, gus_BitloadExceptionCode,  gt_TxPMDControl.us_RMSGI_DS);
                              fprintf(file_pms," %8.1f\t %ld\t %ld\t %ld\t   %ld\t  %ld\t  %ld\t  %ld\t  %ld\t \n", s_actual_inp, gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[1], gs_Lp_final_LP1, gs_net_datarate_final_LP1, gs_Lp_final_LP0, gs_net_datarate_final_LP0,  gs_MaxToneForFast, gs_saveBitstoreduce, gs_Lp_final_LP1+gs_Lp_final_LP0+gs_saveBitstoreduce);

                        }
                     }


                     // reset all the global variables and pms structure
                     gs_Kp_MDF_final= 0;
                     gs_Dp_final=0;
                     gs_Mp_final=0;
                     gs_Rp_final=0;
                     gs_Lp_final=0;
                     gs_Tp_final=0;
                     gs_CWSize_final = 0;
                     gs_Sp_final = 0;
                     gs_net_datarate_final = 0;
                     gs_ovhd_rate_final=0;
                     gs_latency_final= 0;
                     gus_BitloadExceptionCode = 0;
                     gs_found_valid_config =0;
                     gs_flag_fixedrate = 0;
                     gs_flag_limitedrate = 0;

                     gt_PMSParams.s_Dp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Mp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Rp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Tp[LP0_DATA_PATH] = 0;
                     gt_PMSParams.s_Lp[LP0_DATA_PATH] = 0 ;

                     gs_iter_conv=0;
                     gus_ncloaded_LP1 = 0;

                     for (i=gs_RxFirstChannel ; i<=gs_RxNumTones; i++)
                     {
                        CLEARTONEFLAG(p_TonesAllocatedtoLP1_DS, i);

                     }


                  } // res rate BC1
                  } // latency

            } //ovhdrate
         } // gs_INP
   } // test_run

   } // test_case

   fcloseall();


 }  // end of main program

   /********************************************************************************
   ;  Subroutine Name: void VerifyBat(void)
   ;
   ;
   ;  Prototype:
   ;     void VerifyBat(void)
   ;
   ;  Input Arguments:
   ;
   ;
   ;  Output Arguments:
   ;
   ;
   ;  Return:
   ;
   ;
   ;  Global Variable used by this file:
   ;
   ;****************************************************************************/

   C_SCOPE int16 VerifyBat(uint8 *psa_Bat)
   {
      FlagT ft_TcmFlag;
      int16 i, s_bits, s_NumLoadedTones;

      if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
      else ft_TcmFlag = gft_TcmFlag;

      s_bits = 0;
      for(i=0; i<gs_RxNumTones; i++) {
         s_bits += psa_Bat[i];
      }

      gus_Rx_Tcm_Num1bits = 0;
      for(i=0, s_NumLoadedTones=0; i<gs_RxNumTones; i++) {
         s_NumLoadedTones += (int16) (psa_Bat[i] > 0);
         if (ft_TcmFlag==TRUE) gus_Rx_Tcm_Num1bits += (int16) (psa_Bat[i] == 1);
      }

      // Update count of # of loaded tones
      gus_ncloaded = (uint16)(s_NumLoadedTones & 0xFFFF);

      if (ft_TcmFlag==TRUE) {
         s_bits -= (4 + ((s_NumLoadedTones - (gus_Rx_Tcm_Num1bits>>1) + 1) >> 1));
      }

      if(s_bits != gs_Lp_final)
         return(FAIL);
      else
         return(SUCCEED);
   }


   /* Dummy Variable to get test_bitload to build */
   PtrToFunc gpF_RxStateFunc; // Global function pointer of RX state function
   /* Dummy Functions to get test_bitload to build */
   void ExceptionHandler(void)
   {
   }


   void FormRInfo2(void)
   {
   }

   void SelectDsRateOption(Option_t *pta_options, int16 *ps_OutRateOption)
   {
   }
   void Pause(int16 s_Marker)
{
}
